overall_rating();

function overall_rating() {
    let template = Template.GetCurrent();
    let models = ["M1", "T1"];

    /* Create a status object to track whether REPORTER Variables are all present and valid.
     * <success> is initially true but will be set to false if anything missing or invalid. */
    let status = { success: true, missing: [], invalid: [] };

    for (let m of models) {
        let head_score = get_variable_value(status, `${m}_HEAD_FINAL_SCORE`, "float");
        let neck_score = get_variable_value(status, `${m}_NECK_FINAL_SCORE`, "float");
        let chest_score = get_variable_value(status, `${m}_CHEST_ABDOMEN_FINAL_SCORE`, "float");
        let pelvis_and_lumbar_score = get_variable_value(status, `${m}_PELVIS_AND_LUMBAR_MODIFIER`, "float");

        let total_score = head_score + neck_score + chest_score + pelvis_and_lumbar_score;

        /** Check if capping limit is "TRUE" for any body region or head excursion zone
         * If it is then total score will automatically be zero. Add an asterisk to the score to indicate that it has been capped. */
        let overal_capping = "FALSE";
        for (let rep_var of Variable.GetAll(template)) {
            if (rep_var.name.endsWith("CAPPING_LIMIT") && rep_var.name.startsWith(`${m}_`) && rep_var.value == "TRUE") {
                total_score = "*0";
                overal_capping = "TRUE";
                break;
            }
        }

        /** create the "CAPPING_LIMIT" variable  */
        new Variable(template, `${m}_CAPPING_LIMIT`, "Capping Limit", overal_capping, "General", false, true);

        new Variable(
            template,
            `${m}_TOTAL_SCORE`,
            "head + neck + chest & abdomen + pelvis & lumbar modifier (0 if any capping limit is TRUE)",
            total_score,
            "General",
            false,
            true
        );
        new Variable(
            template,
            `${m}_MAX_POSSIBLE_SCORE`,
            "Maximum score for Far Side Assessment",
            "12",
            "General",
            false,
            true
        );
    }

    let rac_sim_variables = [
        "M1_DRIVER_HEAD_HIC_RACSIM",
        "M1_DRIVER_HEAD_THREE_MS_EXCEEDENCE_RACSIM",
        "M1_DRIVER_DRIVER_HEAD_EXCURSION_RACSIM",
        "M1_DRIVER_NECK_UPPER_AXIAL_RACSIM",
        "M1_DRIVER_NECK_UPPER_FLEXION_RACSIM",
        "M1_DRIVER_NECK_UPPER_EXTENSION_RACSIM",
        "M1_DRIVER_NECK_LOWER_AXIAL_RACSIM",
        "M1_DRIVER_NECK_LOWER_FLEXION_RACSIM",
        "M1_DRIVER_CHEST_COMPRESSION_MAX_01_RACSIM",
        "M1_DRIVER_CHEST_COMPRESSION_MAX_02_RACSIM",
        "M1_DRIVER_CHEST_COMPRESSION_MAX_03_RACSIM",
        "M1_DRIVER_ABDOMEN_COMPRESSION_MAX_01_RACSIM",
        "M1_DRIVER_ABDOMEN_COMPRESSION_MAX_02_RACSIM",
        "M1_DRIVER_PELVIS_FORCE_RACSIM",
        "M1_DRIVER_LUMBAR_SHEAR_RACSIM",
        "M1_DRIVER_LUMBAR_AXIAL_RACSIM",
        "M1_DRIVER_LUMBAR_TORSION_RACSIM"
    ];

    let rac_test_variables = [
        "T1_DRIVER_HEAD_HIC_RACTEST",
        "T1_DRIVER_HEAD_THREE_MS_EXCEEDENCE_RACTEST",
        "T1_DRIVER_DRIVER_HEAD_EXCURSION_RACTEST",
        "T1_DRIVER_NECK_UPPER_AXIAL_RACTEST",
        "T1_DRIVER_NECK_UPPER_FLEXION_RACTEST",
        "T1_DRIVER_NECK_UPPER_EXTENSION_RACTEST",
        "T1_DRIVER_NECK_LOWER_AXIAL_RACTEST",
        "T1_DRIVER_NECK_LOWER_FLEXION_RACTEST",
        "T1_DRIVER_CHEST_COMPRESSION_MAX_01_RACTEST",
        "T1_DRIVER_CHEST_COMPRESSION_MAX_02_RACTEST",
        "T1_DRIVER_CHEST_COMPRESSION_MAX_03_RACTEST",
        "T1_DRIVER_ABDOMEN_COMPRESSION_MAX_01_RACTEST",
        "T1_DRIVER_ABDOMEN_COMPRESSION_MAX_02_RACTEST",
        "T1_DRIVER_PELVIS_FORCE_RACTEST",
        "T1_DRIVER_LUMBAR_SHEAR_RACTEST",
        "T1_DRIVER_LUMBAR_AXIAL_RACTEST",
        "T1_DRIVER_LUMBAR_TORSION_RACTEST"
    ];

    let dac_variables = [
        "M1_DRIVER_HEAD_HIC_DAC",
        "M1_DRIVER_HEAD_THREE_MS_EXCEEDENCE_DAC",
        "M1_DRIVER_DRIVER_HEAD_EXCURSION_DAC",
        "M1_DRIVER_NECK_UPPER_AXIAL_DAC",
        "M1_DRIVER_NECK_UPPER_FLEXION_DAC",
        "M1_DRIVER_NECK_UPPER_EXTENSION_DAC",
        "M1_DRIVER_NECK_LOWER_AXIAL_DAC",
        "M1_DRIVER_NECK_LOWER_FLEXION_DAC",
        "M1_DRIVER_CHEST_COMPRESSION_MAX_01_DAC",
        "M1_DRIVER_CHEST_COMPRESSION_MAX_02_DAC",
        "M1_DRIVER_CHEST_COMPRESSION_MAX_03_DAC",
        "M1_DRIVER_ABDOMEN_COMPRESSION_MAX_01_DAC",
        "M1_DRIVER_ABDOMEN_COMPRESSION_MAX_02_DAC",
        "M1_DRIVER_PELVIS_FORCE_DAC",
        "M1_DRIVER_LUMBAR_SHEAR_DAC",
        "M1_DRIVER_LUMBAR_AXIAL_DAC",
        "M1_DRIVER_LUMBAR_TORSION_DAC"
    ];

    /** Creates missing variable for RACSIM and AC_LIMIT */
    for (let i = 0; i < rac_sim_variables.length; i++) {
        get_variable_value(status, rac_sim_variables[i], "float", true);
        get_variable_value(status, rac_sim_variables[i].replace("RACSIM", "AC_LIMIT"), "float", true);
    }

    /** Initialise "DAC" to "Pass" */
    let dac = "Pass";

    /** Creates missing variable for RACTEST,
     * 1. Sets DAC to missing if RACTEST is missing
     * 2. Sets DAC to missing if RACTEST is bigger than 0.5 but RACSIM is missing and sets component DAC to missing
     * 3. Sets DAC to missing if RACTEST is bigger than 0.5 but component DAC is missing
     * 4. Sets DAC to fail if RACTEST is bigger than or equal to 0.5 and component DAC is bigger than or equal to 0.3 */
    for (let i = 0; i < rac_test_variables.length; i++) {
        let sim_value = get_variable_value(status, rac_sim_variables[i], "float");
        let rac_test_value = get_variable_value(status, rac_test_variables[i], "float", true);
        /* Replace RACTEST with DAC */
        let dac_value = get_variable_value(status, dac_variables[i], "float");
        if (rac_test_value == "Missing" || isNaN(rac_test_value) || rac_test_value == null) {
            dac = "Missing";
        } else if (rac_test_value >= 0.5) {
            if (sim_value == "Missing" || isNaN(sim_value) || sim_value == null) {
                dac = "Missing";
                new Variable(template, dac_variables[i], "DAC", "Missing", "General", false, true);
            } else if (dac_value == "Missing" || isNaN(dac_value) || dac_value == null) {
                dac = "Missing";
                new Variable(template, dac_variables[i], "DAC", "Missing", "General", false, true);
            } else if (dac_value >= 0.3) {
                dac = "Fail";
            }
        } else if (rac_test_value < 0.5 && (sim_value == "Missing" || isNaN(sim_value) || sim_value == null)) {
            /* Sometimes RACTEST might pass but RACSIM is missing, in this case we need to create an empty variable for the components DAC */
            new Variable(template, dac_variables[i], "DAC", "", "General", false, true);
        }
    }
    new Variable(template, "DAC", "DAC", dac, "General", false, true);
}
